Attribute VB_Name = "mdNormalPlane"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function NormalPlane(line As aLine, param As Double, workplaneName, sketchName, bNoSketch, color)

'Convenience Function to create a plane normal to a line or an arc

'Get the ProDESKTOP Application object
GetApplicationObject
    
'Get the Active PartDocument,Design
Dim Part As PartDocument
Set Part = app.GetActiveDoc

'Get the Design
Dim Design As aDesign
Set Design = Part.GetDesign
    
'check if line is present
If line Is Nothing Then
    MsgBox ("Create a Line")
    Set line = Part.GetSingleSelection(LineClass, 2)
Else
    Dim blnLine As Boolean
    blnLine = line.IsA("Line")
End If

If blnLine Then
            
    Dim curve As zCurve
    Set curve = line.GetGeometry
    
    Dim centerpoint As aPoint
    Set centerpoint = line.GetCenterPoint
    
    'check if the line is a zStraight or a zCircle or a zCircularArc
    Dim Mode As Integer
    If centerpoint Is Nothing Then
        Mode = 0
    Else
        Mode = 1
    End If
       
    Dim midpoint As zVector
    
    If Mode = 0 Then
    
        Dim straight As zStraight
        Set straight = curve
        Dim startpoint As zVector
        Dim endpoint As zVector
            
        'Get the Start,End and the Mid Point of the Line
        Set startpoint = straight.GetStart
        Set endpoint = straight.GetEnd
        
        'Get the Midpoint from the specified Param
        Set midpoint = startpoint.Add(endpoint).Multiply(param)
                
        'Get the Vector fro the start and end points
        Dim vec As zVector
        Set vec = endpoint.subtract(startpoint)
        
        x = vec.GetAt(0)
        y = vec.GetAt(1)
        z = vec.GetAt(2)
        
        'Create a direction from the vector obtained
        Dim dir As zDirection
        'Set dir = app.GetClass("DirectionVect").CreateDirectionVect(vec)
        Set dir = vec.GetDirection
        
            
    Else
        
         Dim arc As zCircularArc
         Set arc = curve
         
         'Get the direction for the arc
         Dim direction As zDirection
         Set direction = arc.GetDirection
         
         Dim xx As Double
         Dim yy As Double
         Dim zz As Double
         
         xx = direction.GetAt(0)
         yy = direction.GetAt(1)
         zz = direction.GetAt(2)
                  
         Dim vecABC As zVector
         Set vecABC = app.GetClass("Vector").CreateVector(xx, yy, zz)
                  
         'Get the Center,Start, and End Point of the arc.
         Dim center As zVector
         Set center = arc.GetCenter()
         Dim startpt As zVector
         Set startpt = arc.GetStart()
         Dim endpt As zVector
         Set endpt = arc.GetEnd()
        
        'Get the Vectors between the Start,End point and the Center Point
         Dim startvec As zVector
         Set startvec = startpt.subtract(center)
         Set endvec = endpt.subtract(center)
         
         'Get the angle between the Start and End vectors
         cos_of_angle = startvec.Dot(endvec)
         pAngle = Atn(-cos_of_angle / Sqr(-cos_of_angle * cos_of_angle + 1)) + 2 * Atn(1)
         pAngle = pAngle * param
         
         'Create an midpoint
         Dim intermidiatevec As zVector
         Set intermidiatevec = startvec.rotate(direction, pAngle)
         Set midpoint = intermidiatevec.Add(center)
         
         Dim intermevector As zVector
         Set intermevector = midpoint.subtract(center)
                  
         Set crsVec = intermevector.Cross(vecABC)
         'Set dir = app.GetClass("DirectionVect").CreateDirectionVect(crsVec)
         Set dir = crsVec.GetDirection
                  
    End If
     
    Dim plane As zBasicPlane
    Set plane = app.GetClass("BasicPlane").CreateBasicPlane(midpoint, dir)
    
    Set NormalPlane = Design.CreateWorkplane(plane, workplaneName)
    
    'Create a sketch with the given sketch name
    If Not bNoSketch Then
    
        Dim NormalPlaneSketch As aSketch
        Set NormalPlaneSketch = NormalPlane.CreateSketch(sketchName)
        
        'Set the color for the sketch
        If color < 0 Or color > 11 Then
            color = 4
        End If
        
        Set newColor = app.GetClass("Color").CreateColor(1, color * 30, 0.35, 1)
        NormalPlaneSketch.SetColor (newColor)
        Part.SetActiveSketch NormalPlaneSketch
           
    End If
                
End If
  
End Function





